
#version 150 compatibility 

uniform mat4 mat_view ;
uniform mat4 mat_proj ;
uniform mat4 mat_world ;

/// also used in the ps for mixing the group and the demo names
uniform float uni_blend_mix ;

const float scale_group = 0.46 ;
const float scale_demo = 0.31 ;

void main()
{
	// ohh, we know how the quad is build ;)
	gl_TexCoord[0].xy = sign(gl_Vertex.xy) * 0.5 + 0.5 ;

	vec4 vertex = gl_Vertex ;
	
	//
	// component *= base * scale 
	vertex.x *= 1.78 * 3.0 ;
	vertex.y *= mix(scale_group, scale_demo,smoothstep(0.0,1.0,uni_blend_mix)) * 3.0 ;
	vertex.w = 1.0 ;
	
	//vertex.x += 50.0 ;
	vertex.y -= 18.0 ;
	
	// mat_world is a view space trafo. It is the base transformation for the logo.
	gl_Position = mat_proj * mat_world * mat_view * vertex ;
}